-- Messaging for Hostel Check Out Reminder Event (warner Sprint)

SET @parentcategoryId=(SELECT id FROM msg_category WHERE `code`='Hostel');
SET @msgcategoryId=(SELECT MAX(id) FROM msg_category);
INSERT INTO `msg_category` (`id`,`parentCategory`,`code`) VALUES (@msgcategoryId+1,@parentcategoryId,'Hostel Check Out Reminder');

SET @systemmsgeventId=(SELECT MAX(id) FROM system_msg_event);
SET @msgSubCategoryId=(SELECT id FROM msg_category WHERE `code`='Hostel Check Out Reminder');

INSERT INTO `system_msg_event` 
(`id`, `msgConfigLevelId`, `msgSubCategoryId`, `code`, `displayCode`, `eventType`, `whetherRepetationApplicable`, `whetherInitiationRuleApplicable`, `whetherScheduledEvent`, `whetherMsgScopeApplicable`, `whetherImplicitDistributionList`, `whetherDistributionRuleApplicable`, `whetherCommonMsgTemplate`, `description`,`uiDisplayCode`) 
VALUES (@systemmsgeventId+1, '1', @msgSubCategoryId, 'HOSTEL_CHECK_OUT_REMINDER', 'Hostel Check Out Reminder', 'SYSTEM_SCHEDULE', 0, 0, 1, 0, 1, 0, 0, 'Hostel Check Out Reminder','Hostel Check Out Reminder');


SET @sysmsgevtdefaultconfId=(SELECT MAX(id) FROM sys_msg_evt_default_conf);
INSERT INTO `sys_msg_evt_default_conf` (`id`, `systemMsgEventId`, `msgTemplateConfigId`, `initiationRuleProviderId`, `sendingPriority`) 
VALUES (@sysmsgevtdefaultconfId+1, @systemmsgeventId+1, NULL, NULL, 'IMMEDIATE');


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONTEXT_RECORD_ID');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);


SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EVENT_TRIGGER_DATE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='ACADEMY_LOCATION_IDS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

SET @sysmsgevtdefaultscopeId=(SELECT MAX(id) FROM sys_msg_evt_default_scope);
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='EXTRA_PARAMS');
INSERT INTO `sys_msg_evt_default_scope` (`id`, `sysMsgEvtDefaultCnfgId`, `msgScopeParamId`) VALUES (@sysmsgevtdefaultscopeId+1	, @sysmsgevtdefaultconfId+1, @msgScopeParamId);

-- Template data provider for the Appointment

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_DL', 'SQL');

SET @dtproviderId=(SELECT MAX(id) FROM dtprovider);
INSERT INTO `dtprovider` (`id`, `dataProviderName`, `dataProviderType`) VALUES (@dtproviderId+1, 'HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT', 'SQL');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT');

SET @msgRecipientId=(SELECT MAX(id) FROM msg_recipient_type);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT');
INSERT INTO `msg_recipient_type` (`id`, `recipientDataProviderId`, `code`) VALUES (@msgRecipientId+1, @dtproviderId, 'HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT');

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);

SET @sysmsgevtrcptdefaultconfId=(SELECT MAX(id) FROM `sys_msg_evtrcpt_default_conf`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_DL');
SET @recipientTypeId=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT');
INSERT INTO `sys_msg_evtrcpt_default_conf` (`id`, `sysMsgEvtDefaultConfId`, `distrListProviderId`, `distrRuleProviderId`, `recipientTypeId`) 
VALUES (@sysmsgevtrcptdefaultconfId+1, @sysmsgevtdefaultconfId+1, @dtproviderId, NULL, @recipientTypeId);


-- Setting the query for the Applicant distribution list
-- Rcpnt -->1

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId, "SELECT 
    T5.managerId AS USER_ID

FROM
    hostel_room_allotment T1
    left join 
    hostel_room T2 ON T2.id = T1.roomId
        LEFT JOIN
    hostel_floor T3 ON T3.id = T2.floorId
        LEFT JOIN
    hostel_building T4 ON T4.id = T3.buildinglId
        LEFT JOIN
    hostel T5 ON T5.id = T4.hostelId
    
WHERE
    DATE_FORMAT(T1.expectedCheckOutDate, '%Y-%m-%d') = DATE_FORMAT(DATE(NOW()) , '%Y-%m-%d')",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T8.Id AS ID,
    T3.code AS STUDENT_NUMBER,
    T3.printName AS STUDENT_NAME,
    T13.firstName AS FIRST_NAME,
    T13.middleName AS MIDDLE_NAME,
    T13.lastName AS LAST_NAME,
    T13.emailId AS EMAIL_ID,
    T13.mobileNumber AS MOBILE_NO,
    T13.mobileCountryCode AS MOBILE_CODE,
    T11.resourceName AS HOSTEL_BUILDING,
    T10.resourceName AS HOSTEL_FLOOR,
    T9.bedNumber AS HOSTEL_BED_NO,
    T1.expectedCheckOutDate AS EXPECTED_CHECK_OUT_DATE,
    T1.checkInDate AS CHECK_IN_DATE,
    T4.roomNumber AS ROOM_NO,
    T13.printName AS HOSTEL_MANAGER_NAME,
    concat(T14.code,' / ',T14.resourceName) AS HOSTEL_CODE_NAME,
     ml.code as LANGUAGE_KEY
FROM
    hostel_room_allotment T1
       LEFT JOIN
    admission a ON a.id = T1.admissionId
        LEFT JOIN
    students T2 ON T2.userId = a.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    hostel_room T4 ON T4.id = T1.roomId
        LEFT JOIN
    hostel_floor T5 ON T5.id = T4.floorId
        LEFT JOIN
    hostel_building T6 ON T6.id = T5.buildinglId
        LEFT JOIN
    hostel T7 ON T7.id = T6.hostelId
        LEFT JOIN
    users T8 ON T8.id = T7.managerId
        LEFT JOIN
    hostel_bed T9 ON T9.id = T1.bedId
        LEFT JOIN
    resources T10 ON T10.id = T5.resourceId
        LEFT JOIN
    resources T11 ON T11.id = T6.resourceId
        LEFT JOIN
    staffs T12 ON T12.userId = T8.id
    LEFT JOIN
    persons T13 ON T13.id = T12.personId
LEFT JOIN
    multi_language ml on T13.correspondence_language=ml.id
LEFT JOIN
    resources T14 ON T14.id = T7.resourceId
WHERE T8.id in (namedParams) and
    DATE_FORMAT(T1.expectedCheckOutDate, '%Y-%m-%d') = DATE_FORMAT(DATE(NOW()) , '%Y-%m-%d')
        AND T1.allotmentStatus NOT IN ('CHECKED_OUT' , 'CANCELLED')",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "code",
            "resultKey": "STUDENT_NUMBER",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "resourceName",
            "resultKey": "HOSTEL_BUILDING",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "resourceName",
            "resultKey": "HOSTEL_FLOOR",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "bedNumber",
            "resultKey": "HOSTEL_BED_NO",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "expectedCheckOutDate",
            "resultKey": "EXPECTED_CHECK_OUT_DATE",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "checkInDate",
            "resultKey": "CHECK_IN_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "roomNumber",
            "resultKey": "ROOM_NO",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "printName",
            "resultKey": "HOSTEL_MANAGER_NAME",
            "displayCode": "",
            "displayOrder": 9
        },
        {
            "id": 11,
            "value": "resourceName",
            "resultKey": "HOSTEL_CODE_NAME",
            "displayCode": "",
            "displayOrder": 10
        }
    ]
}');

-- Rcpnt -->2

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_DL');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId, "SELECT 
            T1.id as USER_ID
        FROM
            users T1
                LEFT JOIN
            user_academy_locations T2 ON T2.userId = T1.id
                LEFT JOIN
            user_acad_loc_roles T3 ON T3.userAcadLocationId = T2.id
                LEFT JOIN
            roles T4 ON T4.id = T3.roleId
        WHERE
            T4.roleName = (CASE
                WHEN
                    '' <> (SELECT 
                            value
                        FROM
                            drop_down
                        WHERE
                            type = 'Hostel Check-Out Reminder Role')
                THEN
                    (SELECT 
                            value
                        FROM
                            drop_down 
                        WHERE
                            type = 'Hostel Check-Out Reminder Role')
                ELSE 'Residence Admin'
            END)",NULL);


-- Setting the query for the User Recipient

SET @sqlDtproviderId=(SELECT MAX(id) FROM `sql_dtprovider`);
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT');
INSERT INTO `sql_dtprovider` (`id`, `dataProviderId`, `sqlQuery`, `jsonString`) VALUES (@sqlDtproviderId+1,@dtproviderId,
"SELECT 
    T12.userId AS ID,
    T3.code AS STUDENT_NUMBER,
    T3.printName AS STUDENT_NAME,
    T13.firstName AS FIRST_NAME,
    T13.middleName AS MIDDLE_NAME,
    T13.lastName AS LAST_NAME,
    T13.emailId AS EMAIL_ID,
    T13.mobileNumber AS MOBILE_NO,
    T13.mobileCountryCode AS MOBILE_CODE,
    T11.resourceName AS HOSTEL_BUILDING,
    T10.resourceName AS HOSTEL_FLOOR,
    T9.bedNumber AS HOSTEL_BED_NO,
    T1.expectedCheckOutDate AS EXPECTED_CHECK_OUT_DATE,
    T1.checkInDate AS CHECK_IN_DATE,
    T4.roomNumber AS ROOM_NO,
    T13.printName AS HOSTEL_ADMIN_NAME,
	concat(T14.code,' / ',T14.resourceName) AS HOSTEL_CODE_NAME,
     ml.code as LANGUAGE_KEY
FROM
    hostel_room_allotment T1
          LEFT JOIN
    admission a ON a.id = T1.admissionId
        LEFT JOIN
    students T2 ON T2.userId = a.studentId
        LEFT JOIN
    users T3 ON T3.id = T2.userId
        LEFT JOIN
    hostel_room T4 ON T4.id = T1.roomId
        LEFT JOIN
    hostel_floor T5 ON T5.id = T4.floorId
        LEFT JOIN
    hostel_building T6 ON T6.id = T5.buildinglId
        LEFT JOIN
    hostel T7 ON T7.id = T6.hostelId
        LEFT JOIN
    users T8 ON T8.id = T7.managerId
        LEFT JOIN
    hostel_bed T9 ON T9.id = T1.bedId
        LEFT JOIN
    resources T10 ON T10.id = T5.resourceId
        LEFT JOIN
    resources T11 ON T11.id = T6.resourceId
        inner JOIN
    staffs T12 ON T12.userId IN (namedParams)
        LEFT JOIN
    persons T13 ON T13.id = T12.personId
    	LEFT JOIN
    multi_language ml on T13.correspondence_language=ml.id
     LEFT JOIN
    resources T14 ON T14.id = T7.resourceId
WHERE
    T1.id IN (select T1.id as USER_ID from hostel_room_allotment T1 
WHERE
    DATE_FORMAT(T1.expectedCheckOutDate, '%Y-%m-%d') = DATE_FORMAT(DATE(NOW()) , '%Y-%m-%d'))
        AND T1.allotmentStatus NOT IN ('CHECKED_OUT' , 'CANCELLED')",'{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 2,
            "value": "code",
            "resultKey": "STUDENT_NUMBER",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "printName",
            "resultKey": "STUDENT_NAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "resourceName",
            "resultKey": "HOSTEL_BUILDING",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "resourceName",
            "resultKey": "HOSTEL_FLOOR",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "bedNumber",
            "resultKey": "HOSTEL_BED_NO",
            "displayCode": "",
            "displayOrder": 5
        },
        {
            "id": 7,
            "value": "expectedCheckOutDate",
            "resultKey": "EXPECTED_CHECK_OUT_DATE",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "checkInDate",
            "resultKey": "CHECK_IN_DATE",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "roomNumber",
            "resultKey": "ROOM_NO",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "printName",
            "resultKey": "HOSTEL_ADMIN_NAME",
            "displayCode": "",
            "displayOrder": 9
        },{
            "id": 11,
            "value": "resourceName",
            "resultKey": "HOSTEL_CODE_NAME",
            "displayCode": "",
            "displayOrder": 10
        }
    ]
}');

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);

SET @dtprvdrinputparamId=(SELECT MAX(id) FROM dtprvdr_input_param);
SET @dtproviderId=(SELECT id FROM `dtprovider` where `dataProviderName`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_DL');
SET @msgScopeParamId=(SELECT id FROM `msg_scope_param` WHERE paramKey='CONFIG_LEVEL_VALUE');
INSERT INTO `dtprvdr_input_param` (`id`, `dataProviderId`, `paramName`, `paramDataType`, `paramType`, `msgScopeParamId`, `operatorCode`, `additionalInputParamId`) VALUES(@dtprvdrinputparamId+1,@dtproviderId,'T1.id','NUMBER_EQUAL','SCOPEPARAM',@msgScopeParamId,'NUMBER_EQUAL',NULL);


SET @msgtemplateId=(SELECT MAX(id) FROM msg_template);
SET @sysMsgEventId=(SELECT id FROM system_msg_event where code='HOSTEL_CHECK_OUT_REMINDER');

SET @msgtemplateconfigId=(SELECT MAX(id) FROM msg_template_config);
SET @msgSubCategoryId=(SELECT id FROM `msg_category` WHERE `code`='Hostel Check Out Reminder');
SET @recipientTypeId1=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_MANAGER_RECIPIENT');
SET @recipientTypeId2=(SELECT id FROM `msg_recipient_type` WHERE `code`='HOSTEL_CHECK_OUT_REMINDER_HOSTEL_ADMIN_RECIPIENT');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+1,'Hostel Check Out Reminder Manager Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId1,4,NULL,NULL,'Hostel Check Out Reminder Manager Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template_config` (`id`, `code`, `msgSubCategoryId`, `sysMsgEventId`, `recipientTypeId`, `msgMessageTypeId`, `templateDataProviderId`, `templateConfigType`, `templateConfigName`, `whetherBulkMesaging`, `approvalRequired`, `approverId`, `whetherStaticMsg`, `status`, `availableForAdhocMsg`, `academyLocationId`, `authorName`, `authorId`) 
VALUES(@msgtemplateconfigId+2,'Hostel Check Out Reminder Admin Template',@msgSubCategoryId,@sysMsgEventId,@recipientTypeId2,4,NULL,NULL,'Hostel Check Out Reminder Admin Template',NULL,'',NULL,'','APPROVED','','1','System Admin System Admin','1');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+1,@msgtemplateconfigId+1,'1','Hostel Check Out Reminder','<html>
   <head>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
   </head>
   <body>
      <table align="center" style="min-width:700px; max-width:1000px; border-collapse:collapse">
         <tbody>
            <tr style="background-color:#f0f0f0; line-height:20px;">
               <td style="padding:20px 20px 20px 20px;">   
  <p align="left">Dear $recipientData[&quot;hostelManager&quot;],</br></br>
            PFB  the list of Student Number needs to be checked out.</p></p>
 
              
                 
                  <table border="1" cellpadding="1" cellspacing="1" style="width:900px;">
                     <tbody>
                        <tr>
                       	   <td style="text-align: center;font-weight: bold">S.No</td>
                           <td style="text-align: center;font-weight: bold">Student Number</td>
                           <td style="text-align: center;font-weight: bold">Student Name</td>
                           <td style="text-align: center;font-weight: bold"> Hostel code/name</td>
							<td style="text-align: center;font-weight: bold"> Building</td>
							<td style="text-align: center;font-weight: bold">Floor</td>
							<td style="text-align: center;font-weight: bold">Room No.</td>
							<td style="text-align: center;font-weight: bold">Bed No.</td>
                           <td style="text-align: center;font-weight: bold">Checked In Date </td>              
                           <td style="text-align: center;font-weight: bold">Expected Check Out Date </td>
                        </tr>
                        #foreach ($Data in $recipientData[&quot;hostelCheckOutList&quot;] ) 
                        <tr>
                           <td>$velocityCount</td>
                           <td>$Data.studentNumber</td>
                       <td>$Data.studentName</td>
							<td>$Data.hostel</td>
                            <td>$Data.building</td>
							<td>$Data.floor</td>
							<td>$Data.roomNo</td>
							<td>$Data.bedNo</td>
                           <td>$Data.checkedInDate</td> 
                            <td>$Data.expectedCheckOutDate</td> 
                        </tr>
                        #end
                     </tbody>                     
                  </table>            
          
               </td>
            </tr>            
         </tbody>        
      </table>      
   </body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+2,@msgtemplateconfigId+1,'2',null,'<html>
   <head>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
   </head>
   <body>
      <table align="center" style="min-width:700px; max-width:1000px; border-collapse:collapse">
         <tbody>
            <tr style="background-color:#f0f0f0; line-height:20px;">
               <td style="padding:20px 20px 20px 20px;">   
  <p align="left">Dear $recipientData[&quot;hostelManager&quot;],</br></br>
            PFB  the list of Student Number needs to be checked out.</p></p>
 
              
                 
                  <table border="1" cellpadding="1" cellspacing="1" style="width:900px;">
                     <tbody>
                        <tr>
                       	   <td style="text-align: center;font-weight: bold">S.No</td>
                           <td style="text-align: center;font-weight: bold">Student Number</td>
                           <td style="text-align: center;font-weight: bold">Student Name</td>
                           <td style="text-align: center;font-weight: bold"> Hostel code/name</td>
							<td style="text-align: center;font-weight: bold"> Building</td>
							<td style="text-align: center;font-weight: bold">Floor</td>
							<td style="text-align: center;font-weight: bold">Room No.</td>
							<td style="text-align: center;font-weight: bold">Bed No.</td>
                           <td style="text-align: center;font-weight: bold">Checked In Date </td>              
                           <td style="text-align: center;font-weight: bold">Expected Check Out Date </td>
                        </tr>
                        #foreach ($Data in $recipientData[&quot;hostelCheckOutList&quot;] ) 
                        <tr>
                           <td>$velocityCount</td>
                           <td>$Data.studentNumber</td>
                            <td>$Data.studentName</td>
							<td>$Data.hostel</td>
                            <td>$Data.building</td>
							<td>$Data.floor</td>
							<td>$Data.roomNo</td>
							<td>$Data.bedNo</td>
                           <td>$Data.checkedInDate</td> 
                            <td>$Data.expectedCheckOutDate</td> 
                        </tr>
                        #end
                     </tbody>                     
                  </table>            
          
               </td>
            </tr>            
         </tbody>        
      </table>      
   </body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+3,@msgtemplateconfigId+2,'1','Hostel Check Out Reminder','<html>
   <head>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
   </head>
   <body>
      <table align="center" style="min-width:700px; max-width:1000px; border-collapse:collapse">
         <tbody>
            <tr style="background-color:#f0f0f0; line-height:20px;">
               <td style="padding:20px 20px 20px 20px;">   
  <p align="left">Dear $recipientData[&quot;hostelAdmin&quot;],</br></br>
            PFB  the list of Student Number needs to be checked out.</p></p>
 
              
                 
                  <table border="1" cellpadding="1" cellspacing="1" style="width:900px;">
                     <tbody>
                        <tr>
                       	   <td style="text-align: center;font-weight: bold">S.No</td>
                           <td style="text-align: center;font-weight: bold">Student Number</td>
                           <td style="text-align: center;font-weight: bold">Student Name</td>
                           <td style="text-align: center;font-weight: bold"> Hostel code/name</td>
							<td style="text-align: center;font-weight: bold"> Building</td>
							<td style="text-align: center;font-weight: bold">Floor</td>
							<td style="text-align: center;font-weight: bold">Room No.</td>
							<td style="text-align: center;font-weight: bold">Bed No.</td>
                           <td style="text-align: center;font-weight: bold">Checked In Date </td>              
                           <td style="text-align: center;font-weight: bold">Expected Check Out Date </td>
                        </tr>
                        #foreach ($Data in $recipientData[&quot;hostelCheckOutList&quot;] ) 
                        <tr>
                           <td>$velocityCount</td>
                           <td>$Data.studentNumber</td>
                           <td>$Data.studentName</td>
							<td>$Data.hostel</td>
                            <td>$Data.building</td>
							<td>$Data.floor</td>
							<td>$Data.roomNo</td>
							<td>$Data.bedNo</td>
                           <td>$Data.checkedInDate</td> 
                            <td>$Data.expectedCheckOutDate</td> 
                        </tr>
                        #end
                     </tbody>                     
                  </table>            
          
               </td>
            </tr>            
         </tbody>        
      </table>      
   </body>
</html>');

INSERT INTO `msg_template` (`id`, `msgTemplateConfigId`, `msgDeliveryModeId`, `subjectLine`, `msgContent`) 
VALUES (@msgtemplateId+4,@msgtemplateconfigId+2,'2',null,'<html>
   <head>
    <style>
		table, th, td {   
   		 border-collapse: collapse;   		
   		 text-align: center;
		}
	</style>
   </head>
   <body>
      <table align="center" style="min-width:700px; max-width:1000px; border-collapse:collapse">
         <tbody>
            <tr style="background-color:#f0f0f0; line-height:20px;">
               <td style="padding:20px 20px 20px 20px;">   
  <p align="left">Dear $recipientData[&quot;hostelAdmin&quot;],</br></br>
            PFB  the list of Student Number needs to be checked out.</p></p>
 
              
                 
                  <table border="1" cellpadding="1" cellspacing="1" style="width:900px;">
                     <tbody>
                        <tr>
                       	   <td style="text-align: center;font-weight: bold">S.No</td>
                           <td style="text-align: center;font-weight: bold">Student Number</td>
                           <td style="text-align: center;font-weight: bold">Student Name</td>
                           <td style="text-align: center;font-weight: bold"> Hostel code/name</td>
							<td style="text-align: center;font-weight: bold"> Building</td>
							<td style="text-align: center;font-weight: bold">Floor</td>
							<td style="text-align: center;font-weight: bold">Room No.</td>
							<td style="text-align: center;font-weight: bold">Bed No.</td>
                           <td style="text-align: center;font-weight: bold">Checked In Date </td>              
                           <td style="text-align: center;font-weight: bold">Expected Check Out Date </td>
                        </tr>
                        #foreach ($Data in $recipientData[&quot;hostelCheckOutList&quot;] ) 
                        <tr>
                           <td>$velocityCount</td>
                            <td>$Data.studentNumber</td>
                            <td>$Data.studentName</td>
							<td>$Data.hostel</td>
                            <td>$Data.building</td>
							<td>$Data.floor</td>
							<td>$Data.roomNo</td>
							<td>$Data.bedNo</td>
                           <td>$Data.checkedInDate</td> 
                            <td>$Data.expectedCheckOutDate</td> 
                        </tr>
                        #end
                     </tbody>                     
                  </table>            
          
               </td>
            </tr>            
         </tbody>        
      </table>      
   </body>
</html>');


set sql_safe_updates=0;
update msg_template_config set templatelanguageValue= 'English' where templatelanguageValue is null;
update msg_template_config set whetherEnabled=1 where whetherEnabled is null;
set sql_safe_updates=1;

-- End Messaging for Hostel Check Out Reminder Event 
